/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power.factory.condition;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.power.factory.condition.ConditionFactory;
import io.github.apace100.origins.registry.ModRegistriesArchitectury;
import io.github.apace100.origins.util.Comparison;
import io.github.apace100.origins.util.SerializableData;
import io.github.apace100.origins.util.SerializableDataType;
import java.util.List;
import net.minecraft.world.biome.Biome;

public class BiomeConditions {
    public static void register() {
        BiomeConditions.register(new ConditionFactory<Biome>(Origins.identifier("constant"), new SerializableData().add("value", SerializableDataType.BOOLEAN), (data, fluid) -> data.getBoolean("value")));
        BiomeConditions.register(new ConditionFactory<Biome>(Origins.identifier("and"), new SerializableData().add("conditions", SerializableDataType.BIOME_CONDITIONS), (data, fluid) -> ((List)data.get("conditions")).stream().allMatch(condition -> condition.test(fluid))));
        BiomeConditions.register(new ConditionFactory<Biome>(Origins.identifier("or"), new SerializableData().add("conditions", SerializableDataType.BIOME_CONDITIONS), (data, fluid) -> ((List)data.get("conditions")).stream().anyMatch(condition -> condition.test(fluid))));
        BiomeConditions.register(new ConditionFactory<Biome>(Origins.identifier("high_humidity"), new SerializableData(), (data, biome) -> biome.func_76736_e()));
        BiomeConditions.register(new ConditionFactory<Biome>(Origins.identifier("temperature"), new SerializableData().add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.FLOAT), (data, biome) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(biome.func_242445_k(), data.getFloat("compare_to"))));
        BiomeConditions.register(new ConditionFactory<Biome>(Origins.identifier("category"), new SerializableData().add("category", SerializableDataType.STRING), (data, biome) -> biome.func_201856_r().func_222352_a().equals(data.getString("category"))));
        BiomeConditions.register(new ConditionFactory<Biome>(Origins.identifier("precipitation"), new SerializableData().add("precipitation", SerializableDataType.STRING), (data, biome) -> biome.func_201851_b().func_222361_a().equals(data.getString("precipitation"))));
    }

    private static void register(ConditionFactory<Biome> conditionFactory) {
        ModRegistriesArchitectury.BIOME_CONDITION.registerSupplied(conditionFactory.getSerializerId(), () -> conditionFactory);
    }
}

